"use strict";
(self["webpackChunk_cattr_frontend_application"] = self["webpackChunk_cattr_frontend_application"] || []).push([["offline-sync"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=script&lang=js":
/*!*****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=script&lang=js ***!
  \*****************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vee_validate__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vee-validate */ "./node_modules/vee-validate/dist/vee-validate.esm.js");
/* harmony import */ var _services_offline_sync_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../services/offline-sync.service */ "./resources/frontend/core/modules/OfflineSync/services/offline-sync.service.js");
/* harmony import */ var _utils_time__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/utils/time */ "./resources/frontend/core/utils/time.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_ResourceSelect_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/components/ResourceSelect.vue */ "./resources/frontend/core/components/ResourceSelect.vue");
/* harmony import */ var _services_resource_user_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/services/resource/user.service */ "./resources/frontend/core/services/resource/user.service.js");
/* harmony import */ var _utils_file__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/utils/file */ "./resources/frontend/core/utils/file.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }







const formatImportResultMessage = (h, params) => {
  const getResultIcon = () => {
    return h('i', {
      class: {
        icon: true,
        'icon-x-circle': !params.item.success,
        'icon-check-circle': params.item.success
      }
    });
  };
  return typeof params.item.message === 'string' ? [h('span', [getResultIcon(h, params), params.item.message])] : Object.entries(params.item.message).map(([key, msg]) => h('span', [getResultIcon(h, params), `${key}: ${msg}`]));
};
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'Page',
  components: {
    ResourceSelect: _components_ResourceSelect_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    ValidationObserver: vee_validate__WEBPACK_IMPORTED_MODULE_6__.ValidationObserver,
    ValidationProvider: vee_validate__WEBPACK_IMPORTED_MODULE_6__.ValidationProvider
  },
  data() {
    return {
      addedIntervals: [],
      addedScreenshots: [],
      service: new _services_offline_sync_service__WEBPACK_IMPORTED_MODULE_0__["default"](),
      intervalsColumns: [{
        title: this.$t('offline_sync.user'),
        render: (h, params) => {
          return h('a', {
            attrs: {
              href: `mailto:${params.item.user.email}`,
              target: '_blank'
            }
          }, params.item.user.full_name);
        }
      }, {
        title: this.$t('offline_sync.task_id'),
        render: (h, params) => {
          return h('router-link', {
            props: {
              to: {
                name: `Tasks.crud.tasks.view`,
                params: {
                  id: params.item.task_id
                }
              }
            }
          }, params.item.task_id);
        }
      }, {
        title: this.$t('offline_sync.start_at'),
        key: 'start_at'
      }, {
        title: this.$t('offline_sync.end_at'),
        key: 'end_at'
      }, {
        title: this.$t('offline_sync.total_time'),
        key: 'total_time'
      }, {
        title: this.$t('offline_sync.result'),
        render: (h, params) => {
          return h('div', {
            class: 'offline-sync__import-result'
          }, formatImportResultMessage(h, params));
        }
      }],
      screenshotsColumns: [{
        title: this.$t('offline_sync.user'),
        render: (h, params) => {
          return h('span', params.item?.user_id ?? '-');
        }
      }, {
        title: this.$t('offline_sync.task_id'),
        render: (h, params) => {
          return h(params.item?.task_id ? 'router-link' : 'span', {
            props: {
              to: {
                name: `Tasks.crud.tasks.view`,
                params: {
                  id: params.item?.task_id
                }
              }
            }
          }, params.item?.task_id ?? '-');
        }
      }, {
        title: this.$t('offline_sync.start_at'),
        key: 'start_at'
      }, {
        title: this.$t('offline_sync.end_at'),
        key: 'end_at'
      }, {
        title: this.$t('offline_sync.total_time'),
        key: 'total_time'
      }, {
        title: this.$t('offline_sync.result'),
        render: (h, params) => {
          return h('div', {
            class: 'offline-sync__import-result'
          }, formatImportResultMessage(h, params));
        }
      }],
      userId: null,
      usersService: new _services_resource_user_service__WEBPACK_IMPORTED_MODULE_4__["default"](),
      screenshotsUploadProgress: null
    };
  },
  methods: {
    async exportTasks() {
      const {
        valid
      } = await this.$refs.user_select.validate(this.userId);
      if (valid) {
        const result = await this.service.download(this.userId);
        const blob = new Blob([result]);
        const aElement = document.createElement('a');
        aElement.setAttribute('download', 'ProjectsAndTasks.cattr');
        const href = URL.createObjectURL(blob);
        aElement.href = href;
        aElement.setAttribute('target', '_blank');
        aElement.click();
        URL.revokeObjectURL(href);
      }
    },
    async uploadIntervals() {
      const file = this.$refs.intervals_file_input.$el.querySelector('input').files[0];
      const {
        valid
      } = await this.$refs.intervals_file.validate(file);
      if (valid) {
        const result = await this.service.uploadIntervals(file);
        if (result.success) {
          this.addedIntervals = result.data.map(el => {
            const timeDiff = moment__WEBPACK_IMPORTED_MODULE_2___default()(el.interval['end_at']).diff(moment__WEBPACK_IMPORTED_MODULE_2___default()(el.interval['start_at'])) / 1000;
            const totalTime = Math.round((timeDiff + Number.EPSILON) * 100) / 100;
            return _objectSpread(_objectSpread({}, el.interval), {}, {
              message: el.message,
              success: el.success,
              total_time: (0,_utils_time__WEBPACK_IMPORTED_MODULE_1__.formatDurationString)(totalTime)
            });
          });
        } else {
          this.addedIntervals = [];
        }
      }
    },
    async uploadScreenshots() {
      const file = this.$refs.screenshots_file_input.$el.querySelector('input').files[0];
      const {
        valid
      } = await this.$refs.screenshots_file.validate(file);
      if (valid) {
        const result = await this.service.uploadScreenshots(file, this.onUploadProgress.bind(this));
        if (result.success) {
          this.addedScreenshots = result.data.map(el => {
            const timeDiff = el.interval ? moment__WEBPACK_IMPORTED_MODULE_2___default()(el.interval['end_at']).diff(moment__WEBPACK_IMPORTED_MODULE_2___default()(el.interval['start_at'])) / 1000 : '-';
            const totalTime = el.interval ? Math.round((timeDiff + Number.EPSILON) * 100) / 100 : '-';
            return _objectSpread(_objectSpread({}, el.interval), {}, {
              message: el.message,
              success: el.success,
              total_time: el.interval ? (0,_utils_time__WEBPACK_IMPORTED_MODULE_1__.formatDurationString)(totalTime) : '-'
            });
          });
        } else {
          this.addedScreenshots = [];
        }
      }
    },
    onUploadProgress(progressEvent) {
      this.screenshotsUploadProgress = {
        progress: +(progressEvent.progress * 100).toFixed(2),
        loaded: progressEvent.loaded,
        total: progressEvent.total,
        humanReadable: `${(0,_utils_file__WEBPACK_IMPORTED_MODULE_5__.humanFileSize)(progressEvent.loaded, true)} / ${(0,_utils_file__WEBPACK_IMPORTED_MODULE_5__.humanFileSize)(progressEvent.total, true)}`,
        speed: `${progressEvent.rate ? (0,_utils_file__WEBPACK_IMPORTED_MODULE_5__.humanFileSize)(progressEvent.rate, true) : '0 kB'}/s`
      };
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=template&id=de578e58&scoped=true":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=template&id=de578e58&scoped=true ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "container"
  }, [_c('h1', {
    staticClass: "page-title"
  }, [_vm._v(_vm._s(_vm.$t('navigation.offline_sync')))]), _vm._v(" "), _c('div', {
    staticClass: "at-container offline-sync"
  }, [_c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-8"
  }, [_c('h2', {
    staticClass: "page-title"
  }, [_vm._v(_vm._s(_vm.$t('offline_sync.projects_and_tasks')))]), _vm._v(" "), _c('validation-observer', {
    ref: "form",
    scopedSlots: _vm._u([{
      key: "default",
      fn: function ({}) {
        return [_c('validation-provider', {
          ref: "user_select",
          attrs: {
            "rules": "required",
            "name": _vm.$t('offline_sync.user'),
            "mode": "passive"
          },
          scopedSlots: _vm._u([{
            key: "default",
            fn: function ({
              errors
            }) {
              return [_c('small', [_vm._v(_vm._s(_vm.$t('offline_sync.user')))]), _vm._v(" "), _c('resource-select', {
                staticClass: "input",
                class: {
                  'at-select--error': errors.length > 0
                },
                attrs: {
                  "service": _vm.usersService
                },
                model: {
                  value: _vm.userId,
                  callback: function ($$v) {
                    _vm.userId = $$v;
                  },
                  expression: "userId"
                }
              }), _vm._v(" "), _c('p', [_vm._v(_vm._s(errors[0]))])];
            }
          }], null, true)
        })];
      }
    }])
  }), _vm._v(" "), _c('at-button', {
    staticClass: "offline-sync__upload-btn",
    attrs: {
      "size": "large",
      "icon": "icon-download",
      "type": "primary"
    },
    on: {
      "click": _vm.exportTasks
    }
  }, [_vm._v(_vm._s(_vm.$t('offline_sync.export')) + "\n                ")])], 1)]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-8"
  }, [_c('h2', {
    staticClass: "page-title"
  }, [_vm._v(_vm._s(_vm.$t('offline_sync.intervals')))]), _vm._v(" "), _c('validation-observer', {
    ref: "form",
    scopedSlots: _vm._u([{
      key: "default",
      fn: function ({}) {
        return [_c('validation-provider', {
          ref: "intervals_file",
          attrs: {
            "rules": `required|ext:cattr|size:${12 * 1024}`,
            "name": _vm.$t('offline_sync.intervals_file'),
            "mode": "passive"
          },
          scopedSlots: _vm._u([{
            key: "default",
            fn: function ({
              errors
            }) {
              return [_c('at-input', {
                ref: "intervals_file_input",
                staticClass: "intervals-input",
                attrs: {
                  "name": "intervals-file",
                  "type": "file"
                }
              }), _vm._v(" "), _c('p', [_vm._v(_vm._s(errors[0]))])];
            }
          }], null, true)
        })];
      }
    }])
  }), _vm._v(" "), _c('at-button', {
    staticClass: "offline-sync__upload-btn",
    attrs: {
      "size": "large",
      "icon": "icon-upload",
      "type": "primary"
    },
    on: {
      "click": _vm.uploadIntervals
    }
  }, [_vm._v(_vm._s(_vm.$t('offline_sync.import')) + "\n                ")])], 1)]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "offline-sync__added col-24"
  }, [_c('h5', [_vm._v(_vm._s(_vm.$t('offline_sync.added_intervals')))]), _vm._v(" "), _c('at-table', {
    attrs: {
      "columns": _vm.intervalsColumns,
      "data": _vm.addedIntervals
    }
  })], 1)]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-8"
  }, [_c('h2', {
    staticClass: "page-title"
  }, [_vm._v(_vm._s(_vm.$t('offline_sync.screenshots')))]), _vm._v(" "), _c('validation-observer', {
    ref: "form",
    scopedSlots: _vm._u([{
      key: "default",
      fn: function ({}) {
        return [_c('validation-provider', {
          ref: "screenshots_file",
          attrs: {
            "rules": `required|ext:cattr`,
            "name": _vm.$t('offline_sync.screenshots_file'),
            "mode": "passive"
          },
          scopedSlots: _vm._u([{
            key: "default",
            fn: function ({
              errors
            }) {
              return [_c('at-input', {
                ref: "screenshots_file_input",
                staticClass: "screenshots-input",
                attrs: {
                  "name": "screenshots-file",
                  "type": "file"
                }
              }), _vm._v(" "), _c('p', [_vm._v(_vm._s(errors[0]))])];
            }
          }], null, true)
        })];
      }
    }])
  }), _vm._v(" "), _c('at-button', {
    staticClass: "offline-sync__upload-btn",
    attrs: {
      "size": "large",
      "icon": "icon-upload",
      "type": "primary"
    },
    on: {
      "click": _vm.uploadScreenshots
    }
  }, [_vm._v(_vm._s(_vm.$t('offline_sync.import')) + "\n                ")]), _vm._v(" "), _vm.screenshotsUploadProgress != null ? _c('div', {
    staticClass: "screenshots-upload-progress"
  }, [_c('at-progress', {
    attrs: {
      "percent": _vm.screenshotsUploadProgress.progress,
      "stroke-width": 15
    }
  }), _vm._v(" "), _c('span', {
    staticClass: "screenshots-upload-progress__total"
  }, [_vm._v(_vm._s(_vm.screenshotsUploadProgress.humanReadable))]), _vm._v(" "), _c('span', {
    staticClass: "screenshots-upload-progress__speed"
  }, [_vm._v(_vm._s(_vm.screenshotsUploadProgress.speed))])], 1) : _vm._e()], 1)]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "offline-sync__added col-24"
  }, [_c('h5', [_vm._v(_vm._s(_vm.$t('offline_sync.added_screenshots')))]), _vm._v(" "), _c('at-table', {
    attrs: {
      "columns": _vm.screenshotsColumns,
      "data": _vm.addedScreenshots
    }
  })], 1)])])]);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./resources/frontend/core/modules/OfflineSync/services/offline-sync.service.js":
/*!**************************************************************************************!*\
  !*** ./resources/frontend/core/modules/OfflineSync/services/offline-sync.service.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ OfflineSyncService; }
/* harmony export */ });
/* harmony import */ var _config_app__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/config/app */ "./resources/frontend/core/config/app.js");

class OfflineSyncService {
  /**
   * API endpoint URL
   * @returns string
   */
  getItemRequestUri() {
    return `offline-sync`;
  }

  /**
   * @param user_id
   * @returns {Promise<AxiosResponse<T>>}
   */
  async download(user_id) {
    const {
      data
    } = await _config_app__WEBPACK_IMPORTED_MODULE_0__["default"].get(this.getItemRequestUri() + `/download-projects-and-tasks/${user_id}`, {
      responseType: 'blob'
    });
    return data;
  }

  /**
   * Upload Intervals.cattr file
   * @returns {Promise<void>}
   * @param payload
   */
  async uploadIntervals(payload) {
    const formData = new FormData();
    formData.append('file', payload);
    const {
      data
    } = await _config_app__WEBPACK_IMPORTED_MODULE_0__["default"].post(this.getItemRequestUri() + '/upload-intervals', formData);
    return data;
  }

  /**
   * Upload Screenshots.cattr file
   * @returns {Promise<void>}
   * @param payload
   * @param progressCallback
   */
  async uploadScreenshots(payload, progressCallback) {
    const formData = new FormData();
    formData.append('file', payload);
    const {
      data
    } = await _config_app__WEBPACK_IMPORTED_MODULE_0__["default"].post(this.getItemRequestUri() + '/upload-screenshots', formData, {
      onUploadProgress: progressCallback
    });
    return data;
  }
}

/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./resources/frontend/core/modules/OfflineSync/components/Page.vue":
/*!*************************************************************************!*\
  !*** ./resources/frontend/core/modules/OfflineSync/components/Page.vue ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Page_vue_vue_type_template_id_de578e58_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Page.vue?vue&type=template&id=de578e58&scoped=true */ "./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=template&id=de578e58&scoped=true");
/* harmony import */ var _Page_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Page.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=script&lang=js");
/* harmony import */ var _Page_vue_vue_type_style_index_0_id_de578e58_scoped_true_lang_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss */ "./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _Page_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _Page_vue_vue_type_template_id_de578e58_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _Page_vue_vue_type_template_id_de578e58_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "de578e58",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/OfflineSync/components/Page.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=script&lang=js":
/*!*************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Page_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Page.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Page_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=template&id=de578e58&scoped=true":
/*!*******************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=template&id=de578e58&scoped=true ***!
  \*******************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Page_vue_vue_type_template_id_de578e58_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Page_vue_vue_type_template_id_de578e58_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Page_vue_vue_type_template_id_de578e58_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Page.vue?vue&type=template&id=de578e58&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=template&id=de578e58&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss":
/*!**********************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss ***!
  \**********************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_Page_vue_vue_type_style_index_0_id_de578e58_scoped_true_lang_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/OfflineSync/components/Page.vue?vue&type=style&index=0&id=de578e58&scoped=true&lang=scss");


/***/ })

}]);