"use strict";
(self["webpackChunk_cattr_frontend_application"] = self["webpackChunk_cattr_frontend_application"] || []).push([["resources_frontend_core_modules_Projects_views_Tasks_vue"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=script&lang=js":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=script&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var moment_timezone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment-timezone */ "./node_modules/moment-timezone/index.js");
/* harmony import */ var moment_timezone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment_timezone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_TeamAvatars__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/components/TeamAvatars */ "./resources/frontend/core/components/TeamAvatars.vue");
/* harmony import */ var _services_resource_project_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/services/resource/project.service */ "./resources/frontend/core/services/resource/project.service.js");
/* harmony import */ var _services_resource_status_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/services/resource/status.service */ "./resources/frontend/core/services/resource/status.service.js");
/* harmony import */ var _services_resource_task_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/services/resource/task.service */ "./resources/frontend/core/services/resource/task.service.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _utils_color__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/utils/color */ "./resources/frontend/core/utils/color.js");
/* harmony import */ var _utils_time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/utils/time */ "./resources/frontend/core/utils/time.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_7__);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }









/* harmony default export */ __webpack_exports__["default"] = ({
  components: {
    TeamAvatars: _components_TeamAvatars__WEBPACK_IMPORTED_MODULE_1__["default"]
  },
  name: 'Tasks',
  data() {
    return {
      projectService: new _services_resource_project_service__WEBPACK_IMPORTED_MODULE_2__["default"](),
      statusService: new _services_resource_status_service__WEBPACK_IMPORTED_MODULE_3__["default"](),
      taskService: new _services_resource_task_service__WEBPACK_IMPORTED_MODULE_4__["default"](),
      project: {},
      statuses: [],
      tasks: [],
      task: null,
      config: {
        moves: function (el, container, handle) {
          return handle.classList.contains('handle');
        }
      },
      isDesktop: false,
      isMobile: false,
      scrollInterval: null,
      mouseX: null,
      isDragging: false,
      edgeThreshold: Math.min(window.innerWidth * 0.1, 100),
      maxScrollSpeed: window.innerWidth * 0.002
    };
  },
  computed: _objectSpread(_objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_8__.mapGetters)('user', ['companyData'])), {}, {
    stages() {
      return this.statuses.map(status => ({
        name: status.name,
        order: this.getStatusByOrder(status.id)
      }));
    },
    blocks() {
      return this.tasks.map(task => ({
        id: +task.id,
        estimate: (0,_utils_time__WEBPACK_IMPORTED_MODULE_6__.formatDurationString)(task.estimate),
        status: this.getStatusName(task.status_id),
        total_spent_time: (0,_utils_time__WEBPACK_IMPORTED_MODULE_6__.formatDurationString)(+task.total_spent_time + +task.total_offset),
        total_spent_time_over: +task.total_spent_time + +task.total_offset,
        estimate_over: task.estimate,
        due_date: task.due_date
      }));
    }
  }),
  methods: {
    getTextColor: _utils_color__WEBPACK_IMPORTED_MODULE_5__.getTextColor,
    formatDate: _utils_time__WEBPACK_IMPORTED_MODULE_6__.formatDate,
    formatDurationString: _utils_time__WEBPACK_IMPORTED_MODULE_6__.formatDurationString,
    handleClick(e) {
      if (!e.target.closest('.actions__toggle')) {
        if (e.target.closest('.task')) {
          return;
        }
        this.task = null;
      }
    },
    isOverDue(companyTimezone, item) {
      return typeof companyTimezone === 'string' && item.due_date != null && moment_timezone__WEBPACK_IMPORTED_MODULE_0___default().utc(item.due_date).tz(companyTimezone, true).isBefore(moment_timezone__WEBPACK_IMPORTED_MODULE_0___default()());
    },
    checkScreenSize() {
      this.isDesktop = window.screen.width > 900;
      this.checkScreenSizeMobile();
    },
    checkScreenSizeMobile() {
      this.isMobile = window.screen.width < 600;
    },
    isOverTime(item) {
      return item.estimate_over != null && item.total_spent_time_over > item.estimate_over;
    },
    getBlock(id) {
      return this.blocks.find(block => +block.id === +id);
    },
    getTask(id) {
      return this.tasks.find(task => +task.id === +id);
    },
    getStatusByName(name) {
      return this.statuses.find(status => status.name === name);
    },
    getStatusByOrder(id) {
      const index = this.statuses.findIndex(item => item.id === id);
      return index;
    },
    getStatusName(id) {
      const status = this.statuses.find(status => +status.id === +id);
      if (status !== undefined) {
        return status.name;
      }
      return '';
    },
    onDownMouse(e) {
      if (e.buttons & 1) {
        document.addEventListener('mousemove', this.onMoveMouse);
        document.addEventListener('mouseup', this.onUpMouse);
        this.onScrollMouse();
        this.scrollTimer = setInterval(this.onScrollMouse, 1);
      }
    },
    onMove(e) {
      this.mouseX = e.touches[0].clientX;
    },
    onMoveMouse(e) {
      this.mouseX = e.clientX;
    },
    onUpMouse(e) {
      document.removeEventListener('mousemove', this.onMoveMouse);
      document.removeEventListener('mouseup', this.onUpMouse);
      clearInterval(this.scrollTimer);
    },
    onDown(e) {
      document.addEventListener('touchmove', this.onMove);
      document.addEventListener('touchend', this.onUp);
      if (!this.isMobile) {
        this.onScrollMouse();
        this.scrollTimer = setInterval(this.onScrollMouse, 1);
      } else {
        this.scrollTimer = setInterval(this.onScrollTimerTouch, 1);
      }
    },
    onScrollTimerTouch() {
      if (this.mouseX < 50) {
        document.querySelector('.drag-container').scrollLeft -= 1;
      }
      if (this.mouseX > window.screen.width - 50) {
        document.querySelector('.drag-container').scrollLeft += 1;
      }
    },
    onScrollMouse() {
      let scrollSpeed = 0;
      if (this.mouseX !== null && this.mouseX < this.edgeThreshold) {
        scrollSpeed = this.maxScrollSpeed * (1 - this.mouseX / this.edgeThreshold);
        document.querySelector('.drag-container').scrollBy(-scrollSpeed, 0);
      } else if (this.mouseX > window.innerWidth - this.edgeThreshold) {
        const distanceToRightEdge = window.innerWidth - this.mouseX;
        scrollSpeed = this.maxScrollSpeed * (1 - distanceToRightEdge / this.edgeThreshold);
        document.querySelector('.drag-container').scrollBy(scrollSpeed, 0);
      }
    },
    onUp(e) {
      document.removeEventListener('touchmove', this.onMove);
      document.removeEventListener('touchend', this.onUp);
      clearInterval(this.scrollTimer);
    },
    onUpMove(e) {
      document.removeEventListener('mousemove', this.onMove);
      document.removeEventListener('mouseend', this.onUpMove);
      document.querySelector('.drag-container').removeEventListener('scroll', this.onDragContainerScroll);
      this.mouseX = null;
      clearInterval(this.scrollTimer);
    },
    changeOrder: (0,lodash__WEBPACK_IMPORTED_MODULE_7__.throttle)(async function (index, direction) {
      const service = this.statusService;
      const item = this.statuses[index];
      const targetIndex = direction === 'left' ? index - 1 : index + 1;
      const targetItem = this.statuses[targetIndex];
      await service.save(_objectSpread(_objectSpread({}, targetItem), {}, {
        order: item.order
      }));
      this.$set(this.statuses, index, _objectSpread(_objectSpread({}, targetItem), {}, {
        order: item.order
      }));
      this.$set(this.statuses, targetIndex, _objectSpread(_objectSpread({}, item), {}, {
        order: targetItem.order
      }));
    }, 1000),
    getHeaderStyle(name) {
      const status = this.getStatusByName(name);
      return {
        background: status.color,
        color: this.getTextColor(status.color)
      };
    },
    async updateBlock(blockId, newStatusName) {
      const block = this.getBlock(blockId);
      const newStatus = this.statuses.find(s => s.name === newStatusName);
      const blockElement = this.$refs.kanban.querySelector(`[data-block-id="${blockId}"]`);
      const prevBlockElement = blockElement.previousSibling;
      const nextBlockElement = blockElement.nextSibling;
      const prevBlockId = prevBlockElement ? +prevBlockElement.getAttribute('data-block-id') : 0;
      const prevTask = prevBlockId ? this.getTask(prevBlockId) : null;
      const nextBlockId = nextBlockElement ? +nextBlockElement.getAttribute('data-block-id') : 0;
      const nextTask = nextBlockId ? this.getTask(nextBlockId) : null;
      let newRelativePosition;
      if (prevTask !== null && nextTask !== null) {
        newRelativePosition = (prevTask.relative_position + nextTask.relative_position) / 2;
      } else if (prevTask !== null) {
        newRelativePosition = prevTask.relative_position + 1;
      } else if (nextTask !== null) {
        newRelativePosition = nextTask.relative_position - 1;
      } else {
        newRelativePosition = 0;
      }
      const task = this.getTask(blockId);
      const updatedTask = await this.taskService.save(_objectSpread(_objectSpread({}, task), {}, {
        users: task.users.map(user => +user.id),
        status_id: newStatus.id,
        relative_position: newRelativePosition
      }));
      const taskIndex = this.tasks.findIndex(t => +t.id === +updatedTask.id);
      if (taskIndex !== -1) {
        const tasks = [...this.tasks];
        tasks.splice(taskIndex, 1, _objectSpread(_objectSpread({}, task), updatedTask));
        tasks.sort((a, b) => a.relative_position - b.relative_position);
        this.tasks = tasks;
      }
    },
    async loadTask(id) {
      this.task = this.getTask(id);
      this.task = (await this.taskService.getItem(id, {
        with: ['users', 'priority', 'project', 'can'],
        withSum: [['workers as total_spent_time', 'duration'], ['workers as total_offset', 'offset']]
      })).data.data;
    },
    viewTask(task) {
      this.$router.push({
        name: 'Tasks.crud.tasks.view',
        params: {
          id: task.id
        }
      });
    },
    editTask(task) {
      this.$router.push({
        name: 'Tasks.crud.tasks.edit',
        params: {
          id: task.id
        }
      });
    },
    async deleteTask(task) {
      const isConfirm = await this.$CustomModal({
        title: this.$t('notification.record.delete.confirmation.title'),
        content: this.$t('notification.record.delete.confirmation.message'),
        okText: this.$t('control.delete'),
        cancelText: this.$t('control.cancel'),
        showClose: false,
        styles: {
          'border-radius': '10px',
          'text-align': 'center',
          footer: {
            'text-align': 'center'
          },
          header: {
            padding: '16px 35px 4px 35px',
            color: 'red'
          },
          body: {
            padding: '16px 35px 4px 35px'
          }
        },
        width: 320,
        type: 'trash',
        typeButton: 'error'
      });
      if (isConfirm !== 'confirm') {
        return;
      }
      await this.taskService.deleteItem(task.id);
      this.$Notify({
        type: 'success',
        title: this.$t('notification.record.delete.success.title'),
        message: this.$t('notification.record.delete.success.message')
      });
      this.task = null;
      const projectId = this.$route.params['id'];
      this.tasks = (await this.taskService.getWithFilters({
        where: {
          project_id: projectId
        },
        orderBy: ['relative_position'],
        with: ['users', 'priority', 'project', 'can'],
        withSum: [['workers as total_spent_time', 'duration'], ['workers as total_offset', 'offset']]
      }, {
        headers: {
          'X-Paginate': 'false'
        }
      })).data;
    }
  },
  async created() {
    const projectId = this.$route.params['id'];
    this.project = (await this.projectService.getItem(projectId)).data;
    this.statuses = (await this.statusService.getWithFilters({
      orderBy: ['order']
    }, {
      headers: {
        'X-Paginate': 'false'
      }
    })).data.data;
    this.tasks = (await this.taskService.getWithFilters({
      where: {
        project_id: projectId
      },
      orderBy: ['relative_position'],
      with: ['users', 'priority', 'project', 'can'],
      withSum: [['workers as total_spent_time', 'duration'], ['workers as total_offset', 'offset']]
    }, {
      headers: {
        'X-Paginate': 'false'
      }
    })).data.data;
  },
  mounted() {
    if (this.$route.query.task) {
      this.loadTask(+this.$route.query.task);
    }
    this.checkScreenSize();
    window.addEventListener('resize', this.checkScreenSize);
    window.addEventListener('click', this.handleClick);
    document.querySelector('.drag-container').addEventListener('scroll', this.onDragContainerScroll);
  },
  beforeDestroy() {
    window.removeEventListener('click', this.handleClick);
    window.removeEventListener('resize', this.checkScreenSize);
    window.removeEventListener('touchstart', this.onDown);
    window.removeEventListener('mousedown', this.onDownMouse);
    document.querySelector('.drag-container').removeEventListener('scroll', this.onDragContainerScroll);
  },
  directives: {
    customScroll: {
      bind: (el, binding) => {
        const extraWidth = 100;
        const scrollbar = document.createElement('div');
        el.appendChild(scrollbar);
        scrollbar.style.height = '20px';
        const targetSelector = binding.value.targetSelector;
        setTimeout(() => {
          const width = document.querySelector(targetSelector).scrollWidth + 100;
          if (scrollbar && width !== null) {
            scrollbar.style.width = `${width}px`;
          }
        }, 1000);
        el.addEventListener('scroll', e => {
          const targetElement = document.querySelector(targetSelector);
          if (targetElement) {
            targetElement.scrollLeft = e.target.scrollLeft;
          }
        });
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=template&id=c34d5fea&scoped=true":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=template&id=c34d5fea&scoped=true ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', [_c('div', {
    staticClass: "crud crud__content"
  }, [_c('div', {
    staticClass: "page-controls"
  }, [_c('h1', {
    staticClass: "page-title crud__title"
  }, [_vm._v(_vm._s(_vm.project.name))]), _vm._v(" "), _c('div', {
    staticClass: "control-items"
  }, [_c('div', {
    staticClass: "control-item"
  }, [_vm.$can('create', 'task') ? _c('at-button', {
    attrs: {
      "type": "primary",
      "size": "large",
      "icon": "icon-edit"
    },
    on: {
      "click": function ($event) {
        return _vm.$router.push({
          name: 'Tasks.crud.tasks.new'
        });
      }
    }
  }, [_vm._v("\n                        " + _vm._s(_vm.$t('projects.add_task')) + "\n                    ")]) : _vm._e()], 1), _vm._v(" "), _c('div', {
    staticClass: "control-item"
  }, [_c('at-button', {
    attrs: {
      "size": "large"
    },
    on: {
      "click": function ($event) {
        return _vm.$router.push({
          name: 'Projects.crud.projects'
        });
      }
    }
  }, [_vm._v("\n                        " + _vm._s(_vm.$t('control.project-list')) + "\n                    ")])], 1), _vm._v(" "), _c('div', {
    staticClass: "control-item"
  }, [_c('at-button', {
    attrs: {
      "size": "large"
    },
    on: {
      "click": function ($event) {
        return _vm.$router.go(-1);
      }
    }
  }, [_vm._v(_vm._s(_vm.$t('control.back')))])], 1)])]), _vm._v(" "), _c('div', {
    ref: "kanban",
    staticClass: "project-tasks_kanban at-container"
  }, [_c('kanban-board', {
    ref: "board",
    attrs: {
      "config": _vm.config,
      "stages": _vm.stages.map(s => s.name),
      "blocks": _vm.blocks
    },
    on: {
      "update-block": _vm.updateBlock
    }
  }, [_vm._l(_vm.stages, function (stage) {
    return _c('div', {
      key: `stage_${stage.name}`,
      staticClass: "status",
      style: _vm.getHeaderStyle(stage.name),
      attrs: {
        "slot": stage.name
      },
      slot: stage.name
    }, [stage.order !== 0 ? _c('at-button', {
      staticClass: "button-kanban",
      style: _vm.getHeaderStyle(stage.name),
      attrs: {
        "type": "text",
        "size": "large",
        "icon": "icon-chevron-left"
      },
      on: {
        "click": function ($event) {
          return _vm.changeOrder(stage.order, 'left');
        }
      }
    }) : _vm._e(), _vm._v(" "), _c('h3', [_vm._v(_vm._s(stage.name))]), _vm._v(" "), stage.order !== _vm.stages.length - 1 ? _c('at-button', {
      staticClass: "button-kanban",
      style: _vm.getHeaderStyle(stage.name),
      attrs: {
        "type": "text",
        "size": "large",
        "icon": "icon-chevron-right"
      },
      on: {
        "click": function ($event) {
          return _vm.changeOrder(stage.order, 'right');
        }
      }
    }) : _vm._e()], 1);
  }), _vm._v(" "), _vm._l(_vm.blocks, function (block) {
    return _c('div', {
      key: `block_${block.id}`,
      class: {
        task: true,
        handle: _vm.isDesktop
      },
      attrs: {
        "slot": block.id
      },
      on: {
        "click": function ($event) {
          return _vm.loadTask(block.id);
        },
        "mousedown": _vm.onDownMouse,
        "touchstart": _vm.onDown,
        "pointerdown": function ($event) {
          _vm.task = null;
        }
      },
      slot: block.id
    }, [_c('h4', {
      staticClass: "task-name"
    }, [_vm._v(_vm._s(_vm.getTask(block.id).task_name))]), _vm._v(" "), _c('at-tag', {
      staticClass: "tag-priority",
      attrs: {
        "color": _vm.getTask(block.id).priority.color
      }
    }, [_vm._v(_vm._s(_vm.getTask(block.id).priority.name))]), _vm._v(" "), _c('p', {
      staticClass: "task-description",
      domProps: {
        "innerHTML": _vm._s(_vm.getTask(block.id).description)
      }
    }), _vm._v(" "), _c('div', {
      staticClass: "task-users"
    }, [_c('div', {
      staticClass: "task__tags"
    }, [_vm.isOverDue(_vm.companyData.timezone, block) ? _c('at-tag', {
      attrs: {
        "color": "error"
      }
    }, [_vm._v(_vm._s(_vm.$t('tasks.due_date--overdue')) + "\n                            ")]) : _vm._e(), _vm._v(" "), _vm.isOverTime(block) ? _c('at-tag', {
      attrs: {
        "color": "warning"
      }
    }, [_vm._v(_vm._s(_vm.$t('tasks.estimate--overtime')) + "\n                            ")]) : _vm._e()], 1), _vm._v(" "), _c('span', {
      staticClass: "total-time-row"
    }, [_c('i', {
      staticClass: "icon icon-clock"
    }), _vm._v("  " + _vm._s(block.estimate) + " " + _vm._s(_vm.$t(`control.of`)) + "\n                            " + _vm._s(block.total_spent_time) + "\n                        ")]), _vm._v(" "), _c('team-avatars', {
      attrs: {
        "users": _vm.getTask(block.id).users
      }
    })], 1), _vm._v(" "), _c('at-button', {
      class: {
        'hide-on-mobile': _vm.isDesktop,
        'move-task': !_vm.isDesktop,
        handle: !_vm.isDesktop
      },
      attrs: {
        "type": "primary",
        "hollow": "",
        "circle": ""
      },
      on: {
        "click": function ($event) {
          $event.stopPropagation();
        }
      }
    })], 1);
  })], 2)], 1)]), _vm._v(" "), _c('div', {
    directives: [{
      name: "custom-scroll",
      rawName: "v-custom-scroll",
      value: {
        targetSelector: '.drag-container'
      },
      expression: "{ targetSelector: '.drag-container' }"
    }],
    class: {
      'scrollbar-top': true,
      'hide-on-mobile': !_vm.isDesktop
    }
  }), _vm._v(" "), _c('transition', {
    attrs: {
      "name": "slide"
    }
  }, [_vm.task ? _c('div', {
    staticClass: "task-view"
  }, [_c('div', {
    staticClass: "actions__toggle"
  }, [_c('div', {
    staticClass: "task-view-header"
  }, [_c('h4', {
    staticClass: "task-view-title"
  }, [_vm._v(_vm._s(_vm.task.task_name))]), _vm._v(" "), _c('p', {
    staticClass: "task-view-description",
    domProps: {
      "innerHTML": _vm._s(_vm.task.description)
    }
  }), _vm._v(" "), _c('div', {
    staticClass: "task-view-close",
    on: {
      "click": function ($event) {
        _vm.task = null;
      }
    }
  }, [_c('span', {
    staticClass: "icon icon-x"
  })])]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-10 label"
  }, [_vm._v(_vm._s(_vm.$t('field.users')) + ":")]), _vm._v(" "), _c('div', {
    staticClass: "col"
  }, [_c('team-avatars', {
    attrs: {
      "users": _vm.task.users
    }
  })], 1)]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-10 label"
  }, [_vm._v(_vm._s(_vm.$t('field.due_date')) + ":")]), _vm._v(" "), _c('div', {
    staticClass: "col"
  }, [_vm._v(_vm._s(_vm.task.due_date ? _vm.formatDate(_vm.task.due_date) : ''))])]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-10 label"
  }, [_vm._v(_vm._s(_vm.$t('field.total_spent')) + ":")]), _vm._v(" "), _c('div', {
    staticClass: "col"
  }, [_vm._v("\n                        " + _vm._s(_vm.task.total_spent_time ? _vm.formatDurationString(+_vm.task.total_spent_time + +_vm.task.total_offset) : '') + "\n                    ")])]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-10 label"
  }, [_vm._v(_vm._s(_vm.$t('field.priority')) + ":")]), _vm._v(" "), _c('div', {
    staticClass: "col"
  }, [_vm._v(_vm._s(_vm.task.priority ? _vm.task.priority.name : ''))])]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-10 label"
  }, [_vm._v(_vm._s(_vm.$t('field.source')) + ":")]), _vm._v(" "), _c('div', {
    staticClass: "col"
  }, [_vm._v(_vm._s(_vm.task.project.source))])]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-10 label"
  }, [_vm._v(_vm._s(_vm.$t('field.created_at')) + ":")]), _vm._v(" "), _c('div', {
    staticClass: "col"
  }, [_vm._v(_vm._s(_vm.formatDate(_vm.task.created_at)))])])]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('at-button', {
    staticClass: "control-item",
    attrs: {
      "size": "large",
      "icon": "icon-eye",
      "title": _vm.$t('control.view')
    },
    on: {
      "click": function ($event) {
        return _vm.viewTask(_vm.task);
      }
    }
  }), _vm._v(" "), _vm.$can('update', 'task', _vm.task) ? _c('at-button', {
    staticClass: "control-item",
    attrs: {
      "size": "large",
      "icon": "icon-edit",
      "title": _vm.$t('control.edit')
    },
    on: {
      "click": function ($event) {
        return _vm.editTask(_vm.task);
      }
    }
  }) : _vm._e(), _vm._v(" "), _vm.$can('delete', 'task', _vm.task) ? _c('at-button', {
    staticClass: "control-item",
    attrs: {
      "size": "large",
      "type": "error",
      "icon": "icon-trash-2",
      "title": _vm.$t('control.delete')
    },
    on: {
      "click": function ($event) {
        return _vm.deleteTask(_vm.task);
      }
    }
  }) : _vm._e()], 1)]) : _vm._e()])], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./resources/frontend/core/modules/Projects/views/Tasks.vue":
/*!******************************************************************!*\
  !*** ./resources/frontend/core/modules/Projects/views/Tasks.vue ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Tasks_vue_vue_type_template_id_c34d5fea_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Tasks.vue?vue&type=template&id=c34d5fea&scoped=true */ "./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=template&id=c34d5fea&scoped=true");
/* harmony import */ var _Tasks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Tasks.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=script&lang=js");
/* harmony import */ var _Tasks_vue_vue_type_style_index_0_id_c34d5fea_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true */ "./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _Tasks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _Tasks_vue_vue_type_template_id_c34d5fea_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _Tasks_vue_vue_type_template_id_c34d5fea_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "c34d5fea",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/Projects/views/Tasks.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=script&lang=js":
/*!******************************************************************************************!*\
  !*** ./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=script&lang=js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Tasks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Tasks.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Tasks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=template&id=c34d5fea&scoped=true":
/*!************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=template&id=c34d5fea&scoped=true ***!
  \************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Tasks_vue_vue_type_template_id_c34d5fea_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Tasks_vue_vue_type_template_id_c34d5fea_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Tasks_vue_vue_type_template_id_c34d5fea_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Tasks.vue?vue&type=template&id=c34d5fea&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=template&id=c34d5fea&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true":
/*!***************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true ***!
  \***************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_Tasks_vue_vue_type_style_index_0_id_c34d5fea_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Projects/views/Tasks.vue?vue&type=style&index=0&id=c34d5fea&lang=scss&scoped=true");


/***/ })

}]);