"use strict";
(self["webpackChunk_cattr_frontend_application"] = self["webpackChunk_cattr_frontend_application"] || []).push([["resources_frontend_core_modules_Tasks_views_TaskRelations_vue"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services_resource_task_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/services/resource/task.service */ "./resources/frontend/core/services/resource/task.service.js");
/* harmony import */ var _services_resource_gantt_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/services/resource/gantt.service */ "./resources/frontend/core/services/resource/gantt.service.js");
/* harmony import */ var _components_RelationsSelector_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/RelationsSelector.vue */ "./resources/frontend/core/modules/Tasks/components/RelationsSelector.vue");
/* harmony import */ var _components_Preloader_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/components/Preloader.vue */ "./resources/frontend/core/components/Preloader.vue");




const tasksService = new _services_resource_task_service__WEBPACK_IMPORTED_MODULE_0__["default"]();
const ganttService = new _services_resource_gantt_service__WEBPACK_IMPORTED_MODULE_1__["default"]();
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'TaskRelations',
  components: {
    Preloader: _components_Preloader_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    RelationsSelector: _components_RelationsSelector_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
  },
  data() {
    return {
      task: {},
      parents: [],
      children: [],
      saving: false,
      fetching: false
    };
  },
  async mounted() {
    try {
      this.fetching = true;
      const task = await tasksService.getItem(this.$route.params.id, {
        with: ['status', 'parents', 'children']
      });
      this.task = task.data.data;
      this.children = this.task.children;
      this.parents = this.task.parents;
      const projectUsers = await this.projectService.getMembers(this.$route.params[this.projectService.getIdParam()]);
      this.projectUsers = projectUsers.data.data.users;
      const params = {
        global_scope: true
      };
      this.users = await this.usersService.getAll({
        params,
        headers: {
          'X-Paginate': 'false'
        }
      });
    } catch (e) {
      //
    } finally {
      this.fetching = false;
    }
  },
  methods: {
    handleCreate(relation) {
      ganttService.createRelation(this.task.id, relation).then(res => {
        this.$Notify({
          type: 'success',
          title: this.$t('notification.record.save.success.title'),
          message: this.$t('notification.record.save.success.message')
        });
        const task = res.data.data;
        if (relation.type === 'follows') {
          this.parents.push(task);
        } else {
          this.children.push(task);
        }
      });
      // .catch(e => {
      //     this.$Notify({
      //         type: 'error',
      //         title: this.$t('notification.save.error.title'),
      //         message: e.response.data.message ?? this.$t('notification.save.error.message'),
      //     });
      // });
    },
    handleUnlink(relatedTask) {
      const isParent = relatedTask.pivot.child_id === this.task.id;
      ganttService.removeRelation(relatedTask.pivot).then(res => {
        this.$Notify({
          type: 'success',
          title: this.$t('notification.record.delete.success.title'),
          message: this.$t('notification.record.delete.success.message')
        });
        if (isParent) {
          this.parents.splice(relatedTask.index, 1);
        } else {
          this.children.splice(relatedTask.index, 1);
        }
      });
    }
  },
  computed: {}
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "container-fluid"
  }, [_c('div', {
    staticClass: "row flex-around"
  }, [_c('div', {
    staticClass: "col-24 col-sm-22 col-lg-20 at-container"
  }, [_c('div', {
    staticClass: "crud crud__content"
  }, [_vm.fetching ? _c('preloader', {
    attrs: {
      "is-transparent": ""
    }
  }) : _vm._e(), _vm._v(" "), _c('div', {
    staticClass: "page-controls"
  }, [_c('h1', {
    staticClass: "page-title crud__title"
  }, [_vm._v("\n                        " + _vm._s(_vm.$t('tasks.relations.for')) + ": " + _vm._s(this.task.task_name) + "\n                    ")]), _vm._v(" "), _c('div', {
    staticClass: "control-items"
  }, [_c('div', {
    staticClass: "control-item"
  }, [_c('at-button', {
    attrs: {
      "size": "large"
    },
    on: {
      "click": function ($event) {
        return _vm.$router.go(-1);
      }
    }
  }, [_vm._v(_vm._s(_vm.$t('control.back')))])], 1)])]), _vm._v(" "), _vm.task.project_id ? _c('relations-selector', {
    attrs: {
      "parents": _vm.parents,
      "children": _vm.children,
      "project-id": _vm.task.project_id,
      "show-controls": true
    },
    on: {
      "unlink": _vm.handleUnlink,
      "createRelation": _vm.handleCreate
    }
  }) : _vm._e()], 1)])])]);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./resources/frontend/core/modules/Tasks/views/TaskRelations.vue":
/*!***********************************************************************!*\
  !*** ./resources/frontend/core/modules/Tasks/views/TaskRelations.vue ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _TaskRelations_vue_vue_type_template_id_7a37c46d_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true */ "./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true");
/* harmony import */ var _TaskRelations_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TaskRelations.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=script&lang=js");
/* harmony import */ var _TaskRelations_vue_vue_type_style_index_0_id_7a37c46d_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true */ "./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _TaskRelations_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _TaskRelations_vue_vue_type_template_id_7a37c46d_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _TaskRelations_vue_vue_type_template_id_7a37c46d_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "7a37c46d",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/Tasks/views/TaskRelations.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=script&lang=js":
/*!***********************************************************************************************!*\
  !*** ./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_TaskRelations_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TaskRelations.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_TaskRelations_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true":
/*!*****************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true ***!
  \*****************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_TaskRelations_vue_vue_type_template_id_7a37c46d_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_TaskRelations_vue_vue_type_template_id_7a37c46d_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_TaskRelations_vue_vue_type_template_id_7a37c46d_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=template&id=7a37c46d&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true":
/*!********************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true ***!
  \********************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_TaskRelations_vue_vue_type_style_index_0_id_7a37c46d_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/Tasks/views/TaskRelations.vue?vue&type=style&index=0&id=7a37c46d&lang=scss&scoped=true");


/***/ })

}]);