/**
 * Copyright 2018 Google Inc. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// If the loader is already loaded, just stop.
if (!self.define) {
  let registry = {};

  // Used for `eval` and `importScripts` where we can't get script URL by other means.
  // In both cases, it's safe to use a global var because those functions are synchronous.
  let nextDefineUri;

  const singleRequire = (uri, parentUri) => {
    uri = new URL(uri + ".js", parentUri).href;
    return registry[uri] || (
      
        new Promise(resolve => {
          if ("document" in self) {
            const script = document.createElement("script");
            script.src = uri;
            script.onload = resolve;
            document.head.appendChild(script);
          } else {
            nextDefineUri = uri;
            importScripts(uri);
            resolve();
          }
        })
      
      .then(() => {
        let promise = registry[uri];
        if (!promise) {
          throw new Error(`Module ${uri} didn’t register its module`);
        }
        return promise;
      })
    );
  };

  self.define = (depsNames, factory) => {
    const uri = nextDefineUri || ("document" in self ? document.currentScript.src : "") || location.href;
    if (registry[uri]) {
      // Module is already loading or loaded.
      return;
    }
    let exports = {};
    const require = depUri => singleRequire(depUri, uri);
    const specialDeps = {
      module: { uri },
      exports,
      require
    };
    registry[uri] = Promise.all(depsNames.map(
      depName => specialDeps[depName] || require(depName)
    )).then(deps => {
      factory(...deps);
      return exports;
    });
  };
}
define(['./workbox-270e9e46'], (function (workbox) { 'use strict';

  self.addEventListener('message', event => {
    if (event.data && event.data.type === 'SKIP_WAITING') {
      self.skipWaiting();
    }
  });

  /**
   * The precacheAndRoute() method efficiently caches and responds to
   * requests for URLs in the manifest.
   * See https://goo.gl/S9QRab
   */
  workbox.precacheAndRoute([{
    "url": "//dist/app.js",
    "revision": "4e3a83aafacdd48037b80ccd97e30a16"
  }, {
    "url": "/dist/app.css",
    "revision": "5af390119a9a6fb07a74a67001f13a9b"
  }, {
    "url": "/dist/app/About.js",
    "revision": "4439d96c28c1e394bf37eb48cdd5d671"
  }, {
    "url": "/dist/app/ApiError.js",
    "revision": "25fed7f6657b11c03887c91138b87ab5"
  }, {
    "url": "/dist/app/DesktopLogin.js",
    "revision": "3cb8e8b95a4f9a2419a7865be501edcc"
  }, {
    "url": "/dist/app/PageForbidden.js",
    "revision": "9549d83f0d7d9c2d4206cbfb8cc28ff3"
  }, {
    "url": "/dist/app/PageNotFound.js",
    "revision": "9525d740f6b0def51d4c51f9043fce2e"
  }, {
    "url": "/dist/app/Register.js",
    "revision": "015c34ea83c80016f64aa75e2a306569"
  }, {
    "url": "/dist/app/ResetPassword.js",
    "revision": "37e7f75d67ad27d38fe016dede425215"
  }, {
    "url": "/dist/app/StorageManagementTab.js",
    "revision": "11d7662bb777bdcbb2ed174c9e6e9db0"
  }, {
    "url": "/dist/app/calendar.js",
    "revision": "65839022d3a3e8de4704b241892ffca3"
  }, {
    "url": "/dist/app/company.js",
    "revision": "e2c78b59c1326a1946b3128ccc60fa77"
  }, {
    "url": "/dist/app/dashboard.js",
    "revision": "70b11e68008deffd76edf70e704c3293"
  }, {
    "url": "/dist/app/desktop-login.js",
    "revision": "967e2457b5aa43104baaee6a635d11fe"
  }, {
    "url": "/dist/app/editview.js",
    "revision": "b7da4a37214ef71bfd5c84ea2c85f19e"
  }, {
    "url": "/dist/app/gantt.js",
    "revision": "593f0548d83811ea945de98de29da79d"
  }, {
    "url": "/dist/app/gridview.js",
    "revision": "bb5a94ff286903c41e2815f9b4ff1fb2"
  }, {
    "url": "/dist/app/itemview.js",
    "revision": "be2164a7fdb8978cc75a021673e23b26"
  }, {
    "url": "/dist/app/login.js",
    "revision": "7710dee89d4294a4e028807e2702faa3"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_af_js.js",
    "revision": "edd3012493de3d39e722bab86f14d2f4"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ar-dz_js.js",
    "revision": "2ba591a2143c1a8b03cfdd6bc89da989"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ar-sa_js.js",
    "revision": "6cd97a4dfa7ec192a48b3eed6e45c60f"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ar_js.js",
    "revision": "c80f4e37161bdc0393d2be485e3e3fc9"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_az_js.js",
    "revision": "a447d82f6b54ca452386db59b3616b44"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_be_js.js",
    "revision": "c4133c618d2a72a73ddd90d067dd783b"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_bg_js.js",
    "revision": "19d9888f55a0d3c10ecdea889c45231f"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_bm_js.js",
    "revision": "5799d57a3691cc77f9b7114c3c17af88"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_bn_js.js",
    "revision": "71b6db7367fb24e1ff743cc96d3f46a5"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ca_js.js",
    "revision": "291ac282cfedbaa548da513d76542368"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_cs_js.js",
    "revision": "572f0bc3f91eb673b3016a2647fb069f"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_cy_js.js",
    "revision": "e25f3ede5b4f0769d97bab17d80e86be"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_da_js.js",
    "revision": "cb00b8de7d60a66e55d9679178a4f29b"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_de_js.js",
    "revision": "5c07773bcfc0b726b4ddabfb1e6f8d96"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_el_js.js",
    "revision": "8dfa1d8fb2d0337ae339cbbda37df47b"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_en_js.js",
    "revision": "4a9bd9cc3287f0c09bc4328b52a317c4"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_eo_js.js",
    "revision": "3f45e46dac121b7a40ee2be54916367c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_af_js.js",
    "revision": "312b1652b83728c0a9d96f3008061e78"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ar-dz_js.js",
    "revision": "9a6300c9644b7c63960b5f84484fe923"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ar-sa_js.js",
    "revision": "a9b35fa52c04ca9464d6a6caf147b7eb"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ar_js.js",
    "revision": "25a806c668cc2fc6c650b5cee85b3eaf"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_az_js.js",
    "revision": "b442e23bdb00268a24f528b4c5a93012"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_be_js.js",
    "revision": "4410ce31f80dcf827dcc5207202ccd19"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_bg_js.js",
    "revision": "c68d13bf3dc9683b0d1345078ad373fa"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_bm_js.js",
    "revision": "3f12e68c17dc7cac97873472b7f6a024"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_bn_js.js",
    "revision": "5b0bd68690ff35fe35868c693f3b7482"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ca_js.js",
    "revision": "cb4e8fc6b38d615d9cd1968a97367b0c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_cs_js.js",
    "revision": "8dae38151e97ff353e09d32e20db4015"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_cy_js.js",
    "revision": "ddd79ebf7e7a2f7c109f721addd53998"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_da_js.js",
    "revision": "6a44bf01cd336d5d82e2a645990f9a44"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_de_js.js",
    "revision": "857c3d953866d91cc5fd8729e4ffaa4e"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_el_js.js",
    "revision": "0e6660ad7d1abf0a8118c2953782561d"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_en_js.js",
    "revision": "7978cddfe5b5392159cb44f47bdc6d0f"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_eo_js.js",
    "revision": "5371b03b3d72da99e194807cf2030320"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_es_js.js",
    "revision": "71d18ff70a65e8c75ededbf764b58d5d"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_et_js.js",
    "revision": "f76afe154b8b8da7e9417d80492f8878"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_fi_js.js",
    "revision": "8eed9abf6c5d6ec7e8d5d61b6c749fe0"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_fr_js.js",
    "revision": "2c0d2f1746aafe8221fa45c6a11816e6"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_gl_js.js",
    "revision": "9885a189b1b2c038cf5e4f8b293d393b"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_gu_js.js",
    "revision": "ece47a6c17d4356fdce67ccd1358d45e"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_he_js.js",
    "revision": "0961f75cc4479558f73ddf8ca87c552c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_hi_js.js",
    "revision": "8ad24ad434438e6e00a000ac16f6912c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_hr_js.js",
    "revision": "6d36ceeb124cb9ea6eeec79597d79f86"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_hu_js.js",
    "revision": "e1d52a42c80c8b93c0eb86959d4388a6"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_id_js.js",
    "revision": "8d03d6a7a4ddf2e26966efc2e35dccce"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_is_js.js",
    "revision": "bfc1d02df4cd7d178f03ae77fa2317ad"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_it_js.js",
    "revision": "b841c3204637c0e7b557bae12408e08f"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ja_js.js",
    "revision": "52057785770f34769ee57f1579fc56c0"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_js.js",
    "revision": "1e776d78a50d6d315e8d741c2b76cab0"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ka_js.js",
    "revision": "13c73a06d0b94ce56e8948398217268d"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_kk_js.js",
    "revision": "be7cf35e3452fd7b6d01b7de9a2767f5"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ko_js.js",
    "revision": "0e1f59a5870b12cc6a7147fa64d6c20d"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_lt_js.js",
    "revision": "9850b514cd6c447abec760c3f7697a21"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_lv_js.js",
    "revision": "a378709b2b3f4d3f9188275bd882ea1e"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_mk_js.js",
    "revision": "25d220580cb78a2e6ad6ca9889335b9b"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ms_js.js",
    "revision": "94133e3bd67ee57c27b7a3216d4f961f"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_nb_js.js",
    "revision": "a025689191141ad64e56407137981c4e"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_nl-be_js.js",
    "revision": "96cfa1ddc765d1758b7415d377fcb68c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_nl_js.js",
    "revision": "a838933227e081ede928f0d32af4908c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_pl_js.js",
    "revision": "1a51dc8e3039eda17ae5a723eda41978"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_pt-br_js.js",
    "revision": "42b610e27d4a95decae0b63df5dee049"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_pt_js.js",
    "revision": "347ce27c388992f6754f8f9caf78abea"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ro_js.js",
    "revision": "8871358c7a04cfba1320da4caba166e4"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ru_js.js",
    "revision": "5016548a85ca2a5c62f06a56a294b85a"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_sl_js.js",
    "revision": "2d603333f48729154ce13a35e696e627"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_sr_js.js",
    "revision": "01bccbe0816b53414c611e6f82c6e2a9"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_sv_js.js",
    "revision": "c09237dfc6198657c447f5a8f0b12bc7"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ta_js.js",
    "revision": "9e4c67f1908435d1e268ef944d09792d"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_te_js.js",
    "revision": "9b8a1c554a158763065b6e9784e15af3"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_th_js.js",
    "revision": "91f4bf9a900d0f23d9f533e56919a724"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_tr_js.js",
    "revision": "f57526a2cc5bd0f92f7079092e2c0e93"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_ug-cn_js.js",
    "revision": "4866d4031dcab4810bc12cdfb17e99fa"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_uk_js.js",
    "revision": "6bb23bd377d5d769706cf961c44bbc86"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_vi_js.js",
    "revision": "fe9dc29aba83d8d93d1f24c6d5bb3b43"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_zh-cn_js.js",
    "revision": "110a36012464bc88fcaa49471bbe292d"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_es_zh-tw_js.js",
    "revision": "d4cba86d9c99009a76cf6f0cf655fbea"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_et_js.js",
    "revision": "fd639d93870d8983c555d99e5685b762"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_fi_js.js",
    "revision": "6a60e75b42ba50727583e826a05b5d1c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_fr_js.js",
    "revision": "45a6aaf7ab6f784158c671e567d15f51"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_gl_js.js",
    "revision": "68680248a4e0e3628f0edc2fcfa275bd"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_gu_js.js",
    "revision": "42f3d9d537565cd3693635e66c8df8ee"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_he_js.js",
    "revision": "0c5e9ead6091dae814691e3013b129d9"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_hi_js.js",
    "revision": "0ec20373ed165ca2b8a4d30f98f6537a"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_hr_js.js",
    "revision": "ec7871fbbe283f3622b4410a89a15960"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_hu_js.js",
    "revision": "560cc7b61277e30e10a85d38a54b8170"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_id_js.js",
    "revision": "536e9c1da43e24c3f27d50e87bcaeec0"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_is_js.js",
    "revision": "3308fad7983d137b1b89f1b0e380b154"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_it_js.js",
    "revision": "f028f1687bfd140e83bb5a8163a3ddae"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ja_js.js",
    "revision": "aa4348bddc0f330ca5b8dfce132981d4"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ka_js.js",
    "revision": "794fa085ea17d6a19ab648b5eac03166"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_kk_js.js",
    "revision": "aeb4b8d1fdc69e8ce604a2b3b9216d06"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ko_js.js",
    "revision": "e17177bc07a22446c48240b04248453d"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_lt_js.js",
    "revision": "d570751bafc68d70a6a0a775d1a5e2fd"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_lv_js.js",
    "revision": "42bdb74030aaefee76450fadfe88426a"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_mk_js.js",
    "revision": "24b037789362603998de92203f93844a"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ms_js.js",
    "revision": "d67e12d0f87dabcb964a9b5a792fe28a"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_nb_js.js",
    "revision": "8274925d6cdb783e5121796062dff820"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_nl-be_js.js",
    "revision": "65b1451e7c157dbc39250046a57c2bad"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_nl_js.js",
    "revision": "adb0a74b050cf72eca1a1a6c9e866ba5"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_pl_js.js",
    "revision": "25a2bf3312205da5d7c4549ec26aacc0"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_pt-br_js.js",
    "revision": "8c669ad894f41175c9c4027845cbfd58"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_pt_js.js",
    "revision": "2c2e0676ab2f25c973df50816170cb1f"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ro_js.js",
    "revision": "0fd2eeeafd530092ba8db561f3bb29e3"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ru_js.js",
    "revision": "19bd1feee515938c9e37ff60706116cf"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_sl_js.js",
    "revision": "9c708d1558ad2456b2463d603a2db473"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_sr_js.js",
    "revision": "8c8c8150898ddce35d01e0296c0e92eb"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_sv_js.js",
    "revision": "d3830995f6a6852bf7907c3907120769"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ta_js.js",
    "revision": "68d562d70cc4f3bad58d7a2297f3060b"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_te_js.js",
    "revision": "8246641e8e5ea475e5ac08332b2c076c"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_th_js.js",
    "revision": "aac23c6da0f942430d4c64f808400f00"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_tr_js.js",
    "revision": "e6f7f7ed3b49604acef501cd55154919"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_ug-cn_js.js",
    "revision": "bfcb80b17ca6af60f1e0b68f25c3fba8"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_uk_js.js",
    "revision": "210e5feb9371b9b1cdb05b63cf29a91b"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_vi_js.js",
    "revision": "4884a2428209c046a386ef5b081f8bfc"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_zh-cn_js.js",
    "revision": "b38666edd18beaa705a495de9488f229"
  }, {
    "url": "/dist/app/node_modules_vue2-datepicker_locale_zh-tw_js.js",
    "revision": "fcf2f1088e44cf1e0417aeea40051e35"
  }, {
    "url": "/dist/app/offline-sync.js",
    "revision": "791f49a550be7f404ebe109fe1d31d88"
  }, {
    "url": "/dist/app/project-groups.js",
    "revision": "5224cc88c7c301ac4d9b0d2bba538516"
  }, {
    "url": "/dist/app/project-report.js",
    "revision": "b633cfc48202f015266b569c34bee7fb"
  }, {
    "url": "/dist/app/report.plannedtime.js",
    "revision": "27c98974f081c9ad0e34f9401ef713d4"
  }, {
    "url": "/dist/app/report.timeuse.js",
    "revision": "55dda1d9ecb843553bcdbe7050b184b9"
  }, {
    "url": "/dist/app/report.universal.js",
    "revision": "cd7f2c73c9f95826dd40fe088aa1062d"
  }, {
    "url": "/dist/app/resources_frontend_core_modules_Projects_views_ProjectMembers_vue.js",
    "revision": "0beb21eb3f6848a4e02ac9a04dda7f96"
  }, {
    "url": "/dist/app/resources_frontend_core_modules_Projects_views_Tasks_vue.js",
    "revision": "d5de74efd1f04500a1f041ecd679539a"
  }, {
    "url": "/dist/app/resources_frontend_core_modules_Tasks_views_TaskRelations_vue.js",
    "revision": "2645c4fe2980c2b4a38ce62782ddb964"
  }, {
    "url": "/dist/app/resources_frontend_core_modules_UniversalReport_views_CreateUniversalReport_vue.js",
    "revision": "d4fb88b291353f433959e16b731202e7"
  }, {
    "url": "/dist/app/resources_frontend_core_modules_UniversalReport_views_EditUniversalReport_vue.js",
    "revision": "699f3a217d63896e83b3dd4e873e3359"
  }, {
    "url": "/dist/app/resources_frontend_core_modules_UniversalReport_views_ViewUniversalReport_vue.js",
    "revision": "e9084a738b7e04238e3568aac40eff89"
  }, {
    "url": "/dist/app/screenshots.js",
    "revision": "afea58d67a5f96e3855bcf4442006962"
  }, {
    "url": "/dist/app/settings.js",
    "revision": "27d517fb8e38e07287ec2cf7f6b1ae26"
  }, {
    "url": "/fonts/feather.eot?06c77b59a68c5b11103a8e38930687b3",
    "revision": "5fad700adc948cb51404d55833347f51"
  }, {
    "url": "/fonts/feather.svg?29ae650770ffb8a6a3ba1b2ee30ec554",
    "revision": "023ba0824a99109c4a63622228dd6354"
  }, {
    "url": "/fonts/feather.ttf?753e97624700c996443438d3682bc9c2",
    "revision": "a940fe89dbfe9d1d89fc1aa0488fe032"
  }, {
    "url": "/fonts/feather.woff?a2603f60a852565b5d5bf348b9999b69",
    "revision": "66cbb621b431bf32041a5c478e5539c0"
  }, {
    "url": "/fonts/vendor/@cattr/ui-kit/src/stylesheet/src/core/feather.eot?06c77b59a68c5b11103a8e38930687b3",
    "revision": "5fad700adc948cb51404d55833347f51"
  }, {
    "url": "/fonts/vendor/@cattr/ui-kit/src/stylesheet/src/core/feather.svg?29ae650770ffb8a6a3ba1b2ee30ec554",
    "revision": "023ba0824a99109c4a63622228dd6354"
  }, {
    "url": "/fonts/vendor/@cattr/ui-kit/src/stylesheet/src/core/feather.ttf?753e97624700c996443438d3682bc9c2",
    "revision": "a940fe89dbfe9d1d89fc1aa0488fe032"
  }, {
    "url": "/fonts/vendor/@cattr/ui-kit/src/stylesheet/src/core/feather.woff?a2603f60a852565b5d5bf348b9999b69",
    "revision": "66cbb621b431bf32041a5c478e5539c0"
  }, {
    "url": "/images/login.svg?df6ce698c334b07f421136b467b7406e",
    "revision": "9c691fc15f4b87e63044903fd4841ed4"
  }], {});

}));
