<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Assets Repository Path
    |--------------------------------------------------------------------------
    |
    | This path contains all the asset files used by your application.
    |
    */

    'base_path' => base_path('public'),

    /*
    |--------------------------------------------------------------------------
    | Default Hash Algorithm
    |--------------------------------------------------------------------------
    |
    | This option controls the default algorithm that will be used to hash
    | assets files used by your application. By default, the sha256 algorithm is
    | used; however, you remain free to modify this option if you wish.
    |
    | Supported: "sha256", "sha384", "sha512"
    |
    */

    'algorithm' => env('SRI_ALGORITHM', 'sha256'),

    /*
    |--------------------------------------------------------------------------
    | Mix SRI Path
    |--------------------------------------------------------------------------
    |
    | This path contains 'mix-sri.json' file generated by Webpack and Laravel
    | Mix using extensions like 'laravel-mix-sri' that generate hashes on
    | build.
    |
    */

    'mix_sri_path' => public_path('mix-sri.json'),

    /*
    |--------------------------------------------------------------------------
    | Default Files and Hashes
    |--------------------------------------------------------------------------
    |
    | Here are referenced the assets and their respective hashes.
    |
    */

    'hashes' => [
        // 'URL' => 'your_hash',
    ],

    /*
    |--------------------------------------------------------------------------
    | Enable Subresource Integrity
    |--------------------------------------------------------------------------
    |
    | This option determines if it should enable the package. Disabled this in
    | local environment specially if you're using BrowserSync or any like it.
    | Defaults to `true`.
    |
    */

    'enabled' => env('SRI_ENABLED', true),

    /*
    |--------------------------------------------------------------------------
    | Dangerously Allow Third Party Assets
    |--------------------------------------------------------------------------
    |
    | This option determines if it should generate a hash for the third party assets.
    | We highly recommend you to set this to false. You should compute the hash
    | for theses assets manually and add them to the "hashes" config key.
    |
    */

    'dangerously_allow_third_party_assets' => false,

];
